import { TabConfig, useTabsManager } from '../../../../hooks/use-tabs-manager';
import { IAbsence } from '@/shared/types/absence';
import { INITIAL_ABSENCE_DATA } from '@/shared/_mock/_absenceUsager';

const absenceUsagerConfig: TabConfig<IAbsence> = {
  type: 'absence',
  listTitle: 'Liste absence',
  newItemTitle: 'Nouveau absence',
  initialData: INITIAL_ABSENCE_DATA,
  getItemCode: (absence) =>
    absence.usager && absence.usager.firstName && absence.usager.lastName
      ? `${absence.usager.firstName} ${absence.usager.lastName}`
      : absence.id,
};

export function useAbsenceUsagerTabs() {
  return useTabsManager<IAbsence>(absenceUsagerConfig);
}

