import { useState, useCallback, useMemo } from 'react';
import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { INITIAL_AGENT_DATA } from '@/shared/_mock/_agent';
import { IAgent } from '@/shared/types/client';


const agentConfig: TabConfig<IAgent> = {
  type: 'agent',
  listTitle: 'Liste des agents',
  newItemTitle: 'Nouvel agent',
  initialData: INITIAL_AGENT_DATA,
 getItemCode: (agent) => {
    if (agent.firstName && agent.lastName) {
      return `${agent.firstName} ${agent.lastName}`;
    }
    return `Agent ${agent.id}`;  
  },
};

export function useAgentTabs() {
  return useTabsManager<IAgent>(agentConfig);
}