import React from 'react';
import Checkbox from '@mui/material/Checkbox';
import TableCell from '@mui/material/TableCell';
import SvgColor from '@/shared/components/svg-color';
import { TableColumn } from '@/shared/types/common';
import TableActionColumn from '@/shared/components/table/table-action-column';
import { AgencyList } from '@/shared/types/infrastructure';
import { ContratStyledRow } from '@/shared/sections/contract/styles';
import { alpha } from '@mui/material';
import { useTheme } from '@mui/material/styles';
import dayjs from 'dayjs';
import { useInfrastructureStore } from '@/shared/api/stores/admin-service/infrastructureStore';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';

type Props = {
  handleEdit: (agency: AgencyList) => void;
  handleDetails: (agency: AgencyList) => void;
  handleCopy: (agency: AgencyList) => void;
  selected: boolean;
  row: AgencyList;
  dense: boolean;
  onSelectRow: VoidFunction;
  columns: TableColumn[];
  handleOpenConsult: (agency: AgencyList) => void;
};

const TOOLTIP_TITLES = {
  active: 'Agence activée',
  inactive: 'Agence désactivée',
};

export default function AgencyTableRow({
  dense,
  row,
  handleEdit,
  handleDetails,
  handleCopy,
  selected,
  onSelectRow,
  columns,
  handleOpenConsult,
}: Props) {
  const theme = useTheme();

  const { toggleAgencyActivation } = useInfrastructureStore();

  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case 'createdAt':
        return dayjs(value).format('DD-MM-YYYY HH:mm');
      default:
        return value;
    }
  };

  return (
    <ContratStyledRow
      hover
      style={{
        cursor: 'pointer',
      }}
    >
     

      {columns.map((column: any,index:number) => (
        <TableCell
          onDoubleClick={() => handleOpenConsult(row)}
          key={column.id}
          align={column.align}
          sx={{ whiteSpace: 'nowrap', py: dense ? 0 : 2,
            ...(index === 0 && {
              position: 'relative',
            })
          }}
        >
          <ConditionalComponent isValid={index === 0}>
            <SvgColor
              src="/assets/icons/ic_border.svg"
              sx={{
                position: 'absolute',
                top: 0,
                left: -4,
                height: '100%',
                color: theme.palette.primary.main,
              }}
            />
          </ConditionalComponent>
          {renderCellContent(column.id, row[column.id as keyof AgencyList])}
        </TableCell>
      ))}
      <TableCell sx={{ px: 1, whiteSpace: 'nowrap', py: 0 }}>
        <TableActionColumn
          handleEdit={() => handleEdit(row)}
          onToggle={(checked) => toggleAgencyActivation(row.id, checked)}
          isActive={row.active}
          tooltipTitles={TOOLTIP_TITLES}
        />
      </TableCell>
    </ContratStyledRow>
  );
}