import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { useRoadMapStore } from '@/shared/api/stores/roadMapStore';
import { INITIAL_SUBMITTED_ROADMAP_DATA, SubmittedRoadMapDTO } from '@/shared/types/roadMap';


export function useSubmittedRoadMapTabs() {
  const { submittedRoadMaps } = useRoadMapStore();

  const oldRoadMapConfig: TabConfig<SubmittedRoadMapDTO> = {
    type: 'roadmap',
    listTitle: 'Liste de feuilles de route',
    newItemTitle: 'Anciennes feuilles de route',
    initialData: INITIAL_SUBMITTED_ROADMAP_DATA,
    getItemCode: (roadmap) => roadmap.driverName,
  };

  return useTabsManager<SubmittedRoadMapDTO>(oldRoadMapConfig);
}
