import React from 'react';
import { _CIRCUIT_STATUS, _TRAJET_DUREES } from "@/shared/_mock/_circuit";
import FontAwesome from "@/shared/components/fontawesome";
import { IChauffeur, Interval } from "@/shared/types/chauffeur";
import { calculationTypeOptions, Circuit, circuitStateOptions, ICircuitContract, ITripDriverAssignment, SaveCircuit } from "@/shared/types/circuit";
import { FormFieldType } from "@/shared/types/common";
import { faAddressCard, faArrowRight, faEuro, faEye, faHashtag, faStickyNote} from "@fortawesome/free-solid-svg-icons";
import { _BINARY_Qst } from '@/shared/_mock/_trajets';

export interface Option {
  value: string;
  label: string;
}

const TRAJET_OPTIONS: Interval[] = [
  { depart: 'Paris', arriver: 'Lyon' },
  { depart: 'Marseille', arriver: 'Nice' },
  { depart: 'Bordeaux', arriver: 'Toulouse' },
];

export const getFormFieldsCircuit = (
  establishmentOptions: Option[], 
  driverOptions: Option[], 
  contractOptions: Option[] = [], 
): FormFieldType<Circuit>[] => [
  {
    name: 'circuitState',
    label: 'État du circuit',
    type: 'select',
    options: circuitStateOptions,
  },
  {
    name: 'colorCode',
    label: 'Code couleur',
    type: 'color',
    placeholder: 'Choisissez une couleur',
    required: true,
  },
  {
    name: 'startDate',
    label: 'Date de début',
    type: 'date',
    required: true,
  },
  {
    name: 'endDate',
    label: 'Date de fin',
    type: 'date',
    required: true,
  },
  {
    name: 'calculationType',
    label: 'Type de calcul',
    type: 'select',
    options: calculationTypeOptions,
  },
  {
    name: 'mainEstablishment',
    label: 'Établissement principal',
    type: 'select',
    placeholder: 'Entrez un nom',
    required: true,
    options: establishmentOptions,
  },
  {
    name: 'timeTolerance',
    label: 'Paramètres trajet',
    type: 'select',
    placeholder: 'Sélectionnez une durée',
    options: _TRAJET_DUREES,
  },
  {
    name: 'mainDriver',
    label: 'Chauffeurs',
    type: 'combobox',
    placeholder: 'Entrez un nom',
    options: driverOptions,
  },
  {
    name: 'contractCode',
    label: 'Contrat',
    type: 'select',
    placeholder: 'Sélectionnez un contrat',
    options: contractOptions,
  },
  {
    name: 'lotNumber',
    label: 'N° de lot',
    type: 'text',
    placeholder: 'Entrez un numéro de lot',
    icon: faHashtag,
  },
  {
    name: 'observation',
    label: "Observation",
    placeholder:"Ajoutez une note ou une observation",
    type: 'textarea',
    icon: faStickyNote,
  },
  
];
export const numeroLotOptions = [
  { value: 'BCI256579345', label: 'BCI256579345' },
  { value: 'BCI256579347', label: 'BCI256579347' },
  { value: 'BCI25657934', label: 'BCI25657934' },
  { value: 'BCI256579349', label: 'BCI256579349' },
  { value: 'BCI256579346', label: 'BCI256579346' },
  { value: 'BCI256579348', label: 'BCI256579348' }
];
export const formFieldsCircuitContrat: FormFieldType<ICircuitContract>[] = [
  {
    name: 'contrat',
    label: 'Contrat',
    type: 'text',
    placeholder: 'Entrez un nom',
    icon: faEye,
  },
  {
    name: 'numeroLot',
    label: 'N° de lot',
    type: 'multiple',
    options:numeroLotOptions
  },
];

export const getFormFieldsTripDriverAssignment = (tripOptions: Option[], driverOptions: Option[]): FormFieldType<ITripDriverAssignment>[] => [
  {
    name: 'tripId',
    label: 'Trajet',
    type: 'select',
    required: true,
    placeholder: 'Sélectionnez un trajet',
    options: TRAJET_OPTIONS.map((trajet) => ({
      value: `${trajet.depart}-${trajet.arriver}`,
      label: (
        <>
          {trajet.depart}
          <FontAwesome icon={faArrowRight} width={12} style={{ padding: '0 4px' }} />
          {trajet.arriver}
        </>
      ),
    })),
  },
  {
    name: 'driverId',
    label: 'Chauffeur',
    placeholder: 'Entrez un nom',
    type: 'select',
    options: driverOptions,
    required: true,
  },
  {
    name: 'assignmentStartDate',
    label: 'A parir du',
    required: true,
    type: 'date',
  },
  {
    name: 'assignmentEndDate',
    label: "Jusqu'au",
    type: 'date',
    required: true,
  },
  {
    name: 'weeklyAssignmentSchedule',
    label: "Jours Attribues",
    type: 'select',
  },
  {
    name: 'observations',
    label: "Observation",
    placeholder:"Ajoutez une note ou une observation",
    type: 'text',
    icon: faStickyNote,
  },
];

export const formConfig : FormFieldType<SaveCircuit>[] = [
    {
      name: 'circuitCode',
      label: 'Code Circuit',
      type: 'text',
      placeholder: '00',
      icon: faHashtag,
      required: true
    },
    {
      name: 'titled',
      label: 'Intitulé',
      type: 'text',
      placeholder: 'Entrez un nom',
      required: true
    },
  ]

export const getEtatColor = (status: string) => {
  switch (status) {
    case 'controle':
      return '#81919A';
    case 'non_controle':
      return '#eab308';
    default:
      return '#F9B90B';
  }
};
