"use client"
import Checkbox from "@mui/material/Checkbox"
import TableCell from "@mui/material/TableCell"

import TableActionColumn from "@/shared/components/table/table-action-column"
import SvgColor from "@/shared/components/svg-color"
import StatusMenu from "@/shared/components/table/StatusMenu"

import type { TableColumn } from "@/shared/types/common"
import { dateFormat, formatDate } from "@/utils/format-time"
import type { IFuelFee } from "@/shared/types/flottes/fuelFee"
import { ContratStyledRow, getStatusColor, StatusChip } from "@/shared/sections/contract/styles"
import { _FUEL_TYPE_OPTIONS } from "@/shared/_mock/flottes/_fuelFees"
import ConditionalComponent from "@/shared/components/table/ConditionalComponent"

type Props = {
  handleEditFuelFee: (fuelFee: IFuelFee) => void
  handleDetailsFuelFee: (fuelFee: IFuelFee) => void
  handleCopyFuelFee: (fuelFee: IFuelFee) => void
  selected: boolean
  row: IFuelFee
  onSelectRow: VoidFunction
  columns: TableColumn[]
}

const TOOLTIP_TITLES = {
  edit: "Modifier frais carburant",
  duplicate: "Copier frais carburant",
  active: "Frais carburant actif",
  inactive: "Frais carburant inactif",
}

export default function FuelFeeTableRow({
  row,
  handleEditFuelFee,
  handleDetailsFuelFee,
  handleCopyFuelFee,
  selected,
  onSelectRow,
  columns,
}: Props) {
  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case "date":
        return formatDate(value, dateFormat.isoDate)
      default:
        return value
    }
  }

  return (
    <ContratStyledRow hover style={{ cursor: "pointer" }}>
      {columns.filter((c)=>c.id !== 'isActive').map((column: any, index: number) => (
        <TableCell 
          onDoubleClick={() => handleDetailsFuelFee(row)}
          key={column.id}
          align={column.align}
          sx={{ whiteSpace: "nowrap", py: column.id === "type" ? 0 : "inherit", ...(index === 0 && {position: "relative"}), }}
        >
            <ConditionalComponent isValid={index === 0}>
            <SvgColor
              src="/assets/icons/ic_border.svg"
              sx={{ position: "absolute", top: 0, left: -4, height: "100%", color: getStatusColor(row.type) }}
            />
          </ConditionalComponent>
          {renderCellContent(column.id, row[column.id as keyof IFuelFee])}
        </TableCell>
      ))}

      <TableCell align="right" sx={{ px: 1, whiteSpace: "nowrap" }}>
        <TableActionColumn
          handleEdit={() => handleEditFuelFee(row)}
          onToggle={(checked) => void 0}
          isActive={true}
          tooltipTitles={TOOLTIP_TITLES}
        />
      </TableCell>
    </ContratStyledRow>
  )
}
