import { type TabConfig, useTabsManager } from "@/hooks/use-tabs-manager"
import { INITIAL_TINKER_TYPE_DATA } from "@/shared/_mock/flottes/_fuelFees"
import { ITankerType } from "@/shared/types/flottes/fuelImport"

const supplierTypeConfig: TabConfig<ITankerType> = {
  type: "pétrolier",
  listTitle: "Liste des pétroliers",
  newItemTitle: "Nouveau pétrolier",
  initialData: INITIAL_TINKER_TYPE_DATA,
  getItemCode: (supplierType) => supplierType.typeTanker,
}

export function useSupplierTypeTabs() {
  return useTabsManager<ITankerType>(supplierTypeConfig)
}
