import { TableConfig, useTableManager } from '@/hooks/use-table-manager';
import { _vehicles } from '@/shared/_mock/flottes/_vehicle';
import { IMileage } from '@/shared/types/flottes/mileage';
import { _mileageList, MILEAGE_TABLE_HEAD } from '@/shared/_mock/flottes/_mileage';

const MileageConfig: TableConfig<IMileage> = {
  initialData: _mileageList,
  defaultTableHead: MILEAGE_TABLE_HEAD,
};

export function useMileageTable() {
  return useTableManager<IMileage>(MileageConfig);
}