import React from "react"
import { Grid } from "@mui/material"
import { TableType, type FormFieldType, type ModeType, type TableColumn } from "@/shared/types/common"
import ActionButtons from "@/shared/components/form/buttons-action"
import EditExportButtons from "@/shared/components/form/edit-export-buttons"
import { interventionformFields } from "../utils/form-fields-intervention"
import { IIntervention } from "@/shared/types/flottes/intervention"

interface InterventionTabProps {
  renderField: (field: FormFieldType<IIntervention>) => React.ReactNode
  intervention?: IIntervention
  mode: ModeType
  onSave: () => void
  onClose: () => void
  onEdit: () => void
  tableHead: TableColumn[]
}

export default function InterventionDetails({tableHead, mode, onSave, onClose, onEdit, renderField, intervention }: InterventionTabProps) {
  const isReadOnly = mode === "view"

  return (
    <>
     {isReadOnly ? (
        <EditExportButtons
          onEdit={onEdit}
          onExport={() => void 0}
          tooltipTitle={TableType.Reparation}
          dataRow={intervention}
          tableHead={tableHead}
        />
      ) : (
        <></>
      )}
      <form>
        <Grid container spacing={5}>
          {interventionformFields.map((field) => (
            <Grid item xs={12} sm={4} key={field.name}>
              {renderField(field)}
            </Grid>
          ))}
          {!isReadOnly ? (
            <Grid item xs={12}>
              <ActionButtons onSave={onSave} onCancel={onClose} mode={mode} />
            </Grid>
          ): <></>}
        </Grid>
      </form>
    </>
  )
}

