import { _MARQUES, _MODELES } from "@/shared/_mock"
import { _CHAUFFEURS } from "@/shared/_mock/_absenceDriver"
import { DEPARTEMENT_OPTIONS } from "@/shared/sections/establishment/attendance/utils/form-fields-attendance"
import { FormFieldType } from "@/shared/types/common"
import { IVehicle } from "@/shared/types/flottes/vehicule"
import { 
  faHashtag,
  faMagnifyingGlassLocation,
  faNoteSticky,
  faTag,
  faGasPump,
} from "@fortawesome/free-solid-svg-icons"
import { _supplierTypes } from "@/shared/_mock/flottes/_supplier"



export const _VEHICLE_TYPES = [
  { value: "berline", label: "Berline" },
  { value: "utilitaire", label: "Utilitaire" },
]

export const _FUEL_TYPES = [
  { value: "hybride", label: "Hybride" },
  { value: "electrique", label: "Électrique" },
]

export const vehicleformFields: FormFieldType<IVehicle>[] = [
  {
    name: 'contratId',
    label: 'Id contrat',
    type: 'text',
    placeholder: '0000 000 0000',
    icon: faHashtag
  },
  {
    name: 'numeroImmatriculation',
    label: 'Immatriculation',
    type: 'text',
    placeholder: 'AAAA 0000 000 0000',
    icon: faTag,
  },
  {
    name: 'marque',
    label: 'Marque',
    type: 'select',
    options: _MARQUES.map((m) => ({ value: m, label: m })),
    placeholder: 'Choisissez une marque',
  },
  {
    name: 'modele',
    label: 'Modèle',
    type: 'select',
    options: _MODELES.map((m) => ({ value: m, label: m })),
    placeholder: 'Choisissez un modèle',
  },
  {
    name: 'chauffeur',
    label: 'Chauffeur',
    type: 'select',
    options: _CHAUFFEURS.map((chauffeur) => ({ value: chauffeur, label: chauffeur })),
    placeholder: "Choisissez un chauffeur",
  },
  {
    name: 'typeVehicule',
    label: 'Type de véhicule',
    type: 'select',
    options: _VEHICLE_TYPES,
    placeholder: 'Choisissez un type',
  },
  {
    name: "dateImmatriculation",
    label: "Date immatriculation",
    type: "date",
  },
  {
    name: 'department',
    label: 'Département',
    type: 'select',
    options: DEPARTEMENT_OPTIONS,
    placeholder: 'Choisissez un Département'
  },
  {
    name: 'nombrePlaces',
    label: 'Nombre de places',
    type:'text',
    icon: faHashtag,
    placeholder: '000',
  },
  {
    name: 'fuelType',
    label: 'Type de carburant',
    type: 'select',
    options: _FUEL_TYPES,
  },
  {
    name: 'providerType',
    label: 'Type fournisseur',
    type: 'select',
    options: _supplierTypes.map((p) => ({ value: p.id, label: p.intitule })),
    placeholder: 'Choisissez un type fournisseur',
    icon: faGasPump,
  },
  {
    name: 'placesFauteuilRoulant',
    label: 'Places fauteuil roulant',
    type:'text',
    icon: faHashtag,
    placeholder: '000',
  },
  {
    name: 'geolocationCode',
    label: 'Code géolocalisation',
    type: 'text',
    placeholder: '0000 0000 000 0000',
    icon: faMagnifyingGlassLocation
  },
  {
    name: "observation",
    label: "Observation",
    type: "textarea",
    placeholder: "Ajoutez une note ou une observation",
    icon: faNoteSticky,
  },
]
