import { type TabConfig, useTabsManager } from "@/hooks/use-tabs-manager"
import { INITIAL_SUPPLIER_TYPE_DATA } from "@/shared/_mock/flottes/_supplier"
import { ISupplierType } from "@/shared/types/flottes/vehicule"

const supplierTypeConfig: TabConfig<ISupplierType> = {
  type: "type de fournisseur",
  listTitle: "Liste des types de fournisseurs",
  newItemTitle: "Nouveau type de fournisseur",
  initialData: INITIAL_SUPPLIER_TYPE_DATA,
  getItemCode: (supplierType) => supplierType.intitule,
}

export function useSupplierTypeTabs() {
  return useTabsManager<ISupplierType>(supplierTypeConfig)
}
