import type React from 'react';
import { Box, Grid, useTheme } from '@mui/material';
import FontAwesome from '@/shared/components/fontawesome';
import {
  faClock,
  faCar,
  faUser,
  faBuilding,
  faMapMarkerAlt,
} from '@fortawesome/free-solid-svg-icons';
import {
  containerStyles,
  InfoItem,
} from '@/shared/components/google-maps/utils/journey-summary-utils';

interface VehicleInfo {
  vehicleId: string;
  driverName: string;
}

interface JourneySummaryProps {
  date?: string;
  isDrawerElement?: boolean;
  vehicleInfo?: VehicleInfo;
  agency?: string;
  department?: string;
  sector?: string;
  showAllInfo?: boolean;
}

export const GeolocSummary: React.FC<JourneySummaryProps> = ({
  date,
  isDrawerElement = false,
  vehicleInfo,
  agency,
  department,
  showAllInfo = false,
  sector,
}) => {
  const theme = useTheme();

  return (
    <Box sx={{ ...containerStyles(showAllInfo) }}>
      <Box sx={{ width: '100%' }}>
        <Grid container spacing={2} sx={{ mb: 2 }}>
          <Grid item xs={12} sm={6} md={4}>
            <InfoItem
              icon={<FontAwesome icon={faClock} color="primary.main" width={16} />}
              label="Date :"
              value={date || '-'}
            />
          </Grid>

          <Grid item xs={12} sm={6} md={4}>
            <InfoItem
              icon={<FontAwesome icon={faUser} color="primary.main" width={16} />}
              label="Chauffeur :"
              value={vehicleInfo?.driverName || '-'}
            />
          </Grid>
          <Grid item xs={12} sm={6} md={4}>
            <InfoItem
              icon={<FontAwesome icon={faCar} color="primary.main" width={16} />}
              label="Véhicule :"
              value={vehicleInfo?.vehicleId || '-'}
            />
          </Grid>
        </Grid>
        <Grid container spacing={2}>
          {agency && (
            <Grid item xs={12} sm={6} md={4}>
              <InfoItem
                icon={<FontAwesome icon={faBuilding} color="primary.main" width={16} />}
                label="Agence :"
                value={agency}
              />
            </Grid>
          )}
          <Grid item xs={12} sm={6} md={4}>
            <InfoItem
              icon={<FontAwesome icon={faMapMarkerAlt} color="primary.main" width={16} />}
              label="Département :"
              value={department || '-'}
            />
          </Grid>
          <Grid item xs={12} sm={6} md={4}>
            <InfoItem
              icon={<FontAwesome icon={faMapMarkerAlt} color="primary.main" width={16} />}
              label="Secteur :"
              value={sector || '-'}
            />
          </Grid>
        </Grid>
      </Box>
    </Box>
  );
};
