import { Chip, TableRow } from '@mui/material';
import { alpha, styled } from '@mui/system';
import { GeolocStatus } from '@/shared/types/geoloc';
import { BaseStyledRow } from '@/shared/sections/contract/styles';
import { HEADER } from '@/layouts/config-layout';

export const GeolocStatusChip = styled(Chip)(({ status, theme }: { status: string; theme: any }) => ({
  '&.MuiChip-root': {
    fontWeight: 500,
    borderRadius: '8px',
    padding: '4px 8px',
    height: '28px',
    minWidth: '80px',
    ...(status === 'En cours' && {
      backgroundColor: '#E9FBF0',
      color: '#36B37E',
    }),
    ...(status === 'Terminé' && {
      backgroundColor: alpha(theme.palette.primary.main, 0.05),
      color: theme.palette.primary.main,
    }),
    ...(status === 'Planifié' && {
      backgroundColor: '#FEF8E7',
      color: '#F9B90B',
    }),
    ...(status === 'Échoué' && {
      backgroundColor: '#FFE1E1',
      color: '#FF3434',
    }),
    ...(status === 'Inconnu' && {
      backgroundColor: '#F4F6F8',
      color: '#637381',
    }),
  },
}));

export const getGeolocStatusColor = (status: GeolocStatus) => {
  switch (status) {
    case GeolocStatus.IN_PROGRESS:
      return '#36B37E';
    case GeolocStatus.COMPLETED:
      return '#36B37E';
    case GeolocStatus.PLANNED:
      return '#F9B90B';
    case GeolocStatus.FAILED:
      return '#FF3434';
    default:
      return '#637381';
  }
};

export const getGeolocStatusLabel = (status: GeolocStatus) => {
  switch (status) {
    case GeolocStatus.IN_PROGRESS:
      return 'En cours';
    case GeolocStatus.COMPLETED:
      return 'Terminé';
    case GeolocStatus.PLANNED:
      return 'Planifié';
    case GeolocStatus.FAILED:
      return 'Échoué';
    default:
      return 'Inconnu';
  }
};

export const GeolocStyledRow = styled(BaseStyledRow)(({ theme }) => ({
  backgroundColor: alpha(theme.palette.primary.main, 0.05),
  '& > *': {
    borderTop: `2px solid white`,
    padding: '8px 12px',
  },
  '&:hover': {
    backgroundColor: alpha(theme.palette.primary.main, 0.1),
    transition: 'background-color 0.2s ease',
  },
  '&.Mui-selected': {
    backgroundColor: alpha(theme.palette.primary.main, 0.15),
    '&:hover': {
      backgroundColor: alpha(theme.palette.primary.main, 0.2),
    },
  },
  position: 'relative',
  borderRadius: '8px',
  marginBottom: '2px',
  height: '20px', 
}));


export const LivePositionIndicator = styled('div')(({ theme }) => ({
  width: 8,
  height: 8,
  borderRadius: '50%',
  backgroundColor: theme.palette.success.main,
  display: 'inline-block',
  marginRight: theme.spacing(1),
  animation: 'pulse 1.5s infinite',
  '@keyframes pulse': {
    '0%': {
      boxShadow: '0 0 0 0 rgba(54, 179, 126, 0.7)',
    },
    '70%': {
      boxShadow: '0 0 0 6px rgba(54, 179, 126, 0)',
    },
    '100%': {
      boxShadow: '0 0 0 0 rgba(54, 179, 126, 0)',
    },
  },
}));
const DRAWER_WIDTH = 680;
// Styles
export const rootStyles = (isDrawerOpen: boolean) => ({
  display: 'flex',
  flexDirection: 'column',
  height: `calc(100vh - ${HEADER.H_DESKTOP + 16}px)`,
  width: isDrawerOpen ? `calc(100% - ${DRAWER_WIDTH}px)` : '100%',
  transition: 'width 0.3s ease-in-out',

});

export const titleStyles = {
  color: 'primary.main',
  fontWeight: (theme: any) => theme.typography.fontWeightBold,
  my: 3,
};

export const autoCompleteStyles = {
  width: { xs: '100%', sm: '32%' },
  minWidth: 180,
  maxWidth: 250,
};

export const inputLabelProps = {
  style: { color: '#673ab7' },
};

export const iconStyles = {
  color: 'primary.main',
  mr: 1,
};

export const textFieldStyles = {
  '& .MuiOutlinedInput-root': {
    borderRadius: '8px',
    '& fieldset': {
      borderColor: 'primary.main',
      borderWidth: '1px',
    },
    '&:hover fieldset': {
      borderColor: 'primary.dark',
    },
    '&.Mui-focused fieldset': {
      borderColor: 'primary.main',
      borderWidth: '2px',
    },
    backgroundColor: 'white',
  },
  '& .MuiInputLabel-root': {
    color: 'primary.main',
    '&.Mui-focused': {
      color: 'primary.main',
    },
  },
};