import { EmployeeEventType } from '@/shared/_mock/_employeeEvents';

export type CalendarViewType = 'dayGridMonth' | 'timeGridWeek' | 'timeGridDay';
export type AgencyType = 'paris' | 'lyon' | 'marseille' | 'all';
export type EventStatus = 'pending' | 'toRenew' | 'expired' | 'renewed';
export type DriverStatus = 'active' | 'inactive' | 'vacation' | 'all';
export type FilterType = 'contract_end' | 'trial_end' | 'document_expiry' | 'custom' | 'all';
export type StatusType = 'active' | 'inactive' | 'vacation' | 'all';

export type FormFieldName = 
  | 'employeeType'
  | 'type'
  | 'employeeId'
  | 'agenceId'
  | 'date'
  | 'hour'
  | 'time'
  | 'notes'
  | 'notifications'
  | 'files'
  | 'comments'
  | 'description'
  | 'status'
  | 'location'
  | 'allDay'
  | 'employeeName';

export type FormFieldOption = {
  value: string;
  label: string;
  color?: string;
};

export interface FormField {
  name: FormFieldName;
  label: string;
  type: 'text' | 'select' | 'date' | 'time' | 'textarea' | 'multiple';
  icon?: any;
  required?: boolean;
  options?: readonly FormFieldOption[] | FormFieldOption[];
  placeholder?: string;
  hasCustomRender?: boolean;
}

export interface CalendarEvent {
  id: string;
  title: string;
  start: string;
  end: string;
  type: FilterType;
  color: string;
  description?: string;
  allDay: boolean;
  status: EventStatus;
  notifications?: string[];
  agency: AgencyType;
  driverStatus: DriverStatus;
  employeeType: 'chauffeur' | 'sedentaire';
  employeeId?: string;
  agenceId?: string;
  employeeName?: string;
  location?: string;
  comments?: string;
  files?: Array<{ name: string; type: string; url: string; }>;
  date?: string;
  hour?: string;
  notes?: string;
  time?: string;
}

export interface DialogProps {
  open: boolean;
  onClose: () => void;
  event?: CalendarEvent;
  onEventUpdate?: (event: CalendarEvent) => void;
  onSubmit?: (eventData: any) => void;
  initialEvent?: any;
  isEditing?: boolean;
} 