import { alpha, styled, TableRow } from "@mui/material";

const BaseStyledRow = styled(TableRow)(({ theme }) => ({
  backgroundColor: 'white',
  '& > *:first-of-type': {
    borderBottomLeftRadius: '10px',
    borderTopLeftRadius: '10px',
  },
  '& > *:last-child': {
    borderTopRightRadius: '10px',
    borderBottomRightRadius: '10px',
  },
}));

export const DocumentStyledRow = styled(BaseStyledRow)(({ theme }) => ({
  '& > *': {
    borderTop: `3px solid ${alpha(theme.palette.primary.main, 0.1)}`,
  }
}));