import { Avatar, Button, Card, Typography } from '@mui/material'
import { Box } from '@mui/system'
import React from 'react'
import PersonIcon from '@mui/icons-material/Person'

const TeamsCard = () => {
    return (
        <Card sx={{padding:4, width: "100%", borderRadius: 1 }}>
            <Typography variant="h5" sx={{ mb: 2, fontWeight: 500 }}>Mes équipes</Typography>

            <Box sx={{ display: 'flex', alignItems: 'center', mb: 3 }}>
                <Avatar sx={{ width: 36, height: 36, mr: 2 }}>
                    <PersonIcon />
                </Avatar>
                <Typography variant="body1" sx={{ fontWeight: 500 }}>DREAM TEAM</Typography>
            </Box>

            <Button
                variant="outlined"
                sx={{
                    borderRadius: 2,
                    textTransform: 'none',
                    px: 3,
                    py: 1,
                    borderColor: '#e0e0e0',
                    color: 'text.primary'
                }}
            >
                Découvrir les équipes
            </Button>
        </Card>
    )
}

export default TeamsCard
