import React, { useEffect } from 'react';
import TableManager from '../../../components/table/table-manager';
import { TableColumn } from '@/shared/types/common';
import HistoriqueTrajetTableRow from '../view/trajet-table-row';
import { ITrajet } from '../../../types/trajet';

interface TrajetTableProps {
  filteredData: ITrajet[];
  table: ReturnType<typeof import('@/shared/components/table/use-tablets').default>;
  tableHead: TableColumn[];
  notFound: boolean;
  filters: Record<string, { value: string; condition: string }>;
  onFilterChange: (key: string, value: string, condition: string) => void;
  handleEdit: (item: ITrajet) => void;
  handleView: (item: ITrajet) => void;
  isSecondaryTable?: boolean
  onStatusChange: (row: ITrajet, newStatus: string, field: keyof ITrajet) => void;
}

export default function TrajetTable({
  filteredData,
  table,
  tableHead,
  notFound,
  filters,
  onFilterChange,
  handleEdit,
  handleView,
  isSecondaryTable,
  onStatusChange
}: TrajetTableProps) {
 

  const renderRow = (row: ITrajet) => {
   
    return (
      <HistoriqueTrajetTableRow
        dense={table.dense}
        key={row.id}
        row={row}
        handleEditContract={(trajet) => {
          console.log("handleEditContract appelé avec:", trajet);
          handleEdit(trajet);
        }}
        handleDetailsContract={(trajet) => {
          console.log("handleDetailsContract appelé avec:", trajet);
          handleView(trajet);
        }}
        selected={table.selected.includes(row.id)}
        onSelectRow={() => table.onSelectRow(row.id)}
        columns={tableHead.slice(0, -1)}
        onStatusChange={onStatusChange}
      />
    );
  };

  return (
    <TableManager
      filteredData={filteredData}
      table={table}
      tableHead={tableHead}
      notFound={notFound}
      filters={filters}
      onFilterChange={onFilterChange}
      renderRow={renderRow}
      sx={isSecondaryTable ? { backgroundColor: 'primary.lighter' } : undefined}
    />
  );
}

