import { ScheduleDTO } from '@/shared/types/amendment';
import type { AmendmentPassengerDetails } from '@/shared/types/ammendment-passenger';
import { ModeType } from '@/shared/types/common';
import type { TimeValue } from '@/shared/types/usager';

export interface FormikAmendmentPassengerDetails
  extends Omit<AmendmentPassengerDetails, 'passengerScheduleWeeks'> {
  weeklySchedules: WeeklyScheduleType;
}

export interface WeeklyScheduleType {
  pair: {
    [key: string]: {
      morning: { aller: TimeValue; retour?: TimeValue };
      evening: { aller?: TimeValue; retour: TimeValue };
    };
  };
  impair: {
    [key: string]: {
      morning: { aller: TimeValue; retour?: TimeValue };
      evening: { aller?: TimeValue; retour: TimeValue };
    };
  };
}

export interface WeekScheduleProps {
  type: "pair" | "impair"
  values: {
    [key: string]: {
      morning: { aller: TimeValue; retour?: TimeValue }
      evening: { aller?: TimeValue; retour: TimeValue }
    }
  }
  onChange: (day: string, period: "morning" | "evening", type: "aller" | "retour", value: TimeValue) => void
  onAddField: (day: string, period: "morning" | "evening", field: "aller" | "retour") => void
  onRemoveField: (day: string, period: "morning" | "evening", field: "aller" | "retour") => void
  onCopy: () => void
  onReset: (periodType: "morning" | "evening") => void
  isReadOnly: boolean
}

export interface HorairesSpecifiqueTabsProps {
  mode: ModeType
  withData: boolean
  title: string
  schedules?: ScheduleDTO[]
  useFormik?: boolean
}