'use client';

import React, { useEffect } from 'react';
import { Box, Stack, IconButton, TableCell, Checkbox } from '@mui/material';
import {
  faFileExport,
  faRotate,
} from '@fortawesome/free-solid-svg-icons';
import { iconButtonStyles } from '@/shared/theme/css';
import FontAwesome from '@/shared/components/fontawesome';
import CustomTooltip from '@/shared/components/tooltips/tooltip-custom';
import { TableConfig, useTableManager } from '@/hooks/use-table-manager';
import TableManager from '@/shared/components/table/table-manager';
import { TrajetStyledRow } from '@/shared/sections/contract/styles';
import { ISuiviDocument } from '@/shared/types/document';
import { _documents, _suiviDocuments, DEFAULT_SUIVI_DOCUMENT_TABLE_HEAD } from '@/shared/_mock/_documents';
import TableFilter from '@/shared/components/table/table-filter';
import { IUsager } from '@/shared/types/usager';
import ExportButton from '@/shared/components/table/table-export-button';
import { TableType } from '@/shared/types/common';
import { IPassengerList } from '@/shared/types/passenger';

interface SuiviDossierFormProps {
  usager?: IPassengerList;
}

export default function SuiviDossierForm({ usager }: SuiviDossierFormProps) {

  const suiviDocumentConfig: TableConfig<ISuiviDocument> = {
    initialData: usager?.email ? _suiviDocuments : [],
    defaultTableHead: DEFAULT_SUIVI_DOCUMENT_TABLE_HEAD,
  };
  
  const {
    table,
    filteredData,
    filters,
    tableHead,
    notFound,
    handleFilterChange,
    handleResetFilters,
    dataToExport,
    handleResetColumns,
    handleColumnsChange,
    handleSave,
    handleDelete,
  } = useTableManager<ISuiviDocument>(suiviDocumentConfig);


  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case 'dateImportation':
      default:
        return value;
    }
  };

  const renderRow = (row: ISuiviDocument) => {
    return (
      <TrajetStyledRow
        key={row.id}
        style={{ cursor: 'pointer' }}
      >

        {tableHead.map((column: any) => (
          <TableCell
            onDoubleClick={() => console.log('view documents')}
            key={column.id}
            align={column.align || 'left'}
            sx={{ whiteSpace: 'nowrap', py: column.id === 'etat' ? 0.2 : table.dense ? 0.5 : 1 }}
          >
            {renderCellContent(column.id, row[column.id as keyof ISuiviDocument])}
          </TableCell>
        ))}
      </TrajetStyledRow>
    );
  };

  return (
    <Box>
      <Stack direction="row" alignItems="center" justifyContent="flex-end" gap="8px" pb={2}>
        <CustomTooltip title="Refresh" arrow>
          <IconButton onClick={handleResetFilters} sx={iconButtonStyles}>
            <FontAwesome icon={faRotate} width={16} />
          </IconButton>
        </CustomTooltip>
        <TableFilter
          onResetFilters={handleResetFilters}
          onFilters={handleFilterChange}
          initialColumns={tableHead}
          type="document"
        />
        <ExportButton
          tooltipTitle={'Exporter'}
          type={TableType.SuiviDocument}
          filteredData={dataToExport}
          tableHead={tableHead}
        />
      </Stack>
      <TableManager
        filteredData={filteredData}
        table={table}
        tableHead={tableHead}
        notFound={notFound}
        filters={filters}
        onFilterChange={handleFilterChange}
        renderRow={renderRow}
        sx={{ backgroundColor: 'primary.lighter' }}
        isTrajetTable={true}
        isWithoutTabs
      />
    </Box>
  );
}

