import { PeriodOfDay } from "./ammendment-passenger";
import { AddressData } from "./common";
import { DaysOfWeek, WeekType } from "./passenger";
import { EtatTrajet } from "./trajet";

export type ICircuit = {
    id: string,
    etat: string,
    codeCircuit: string,
    intitule: string,
    clientDO?: string,
    chauffeur: string,
    type?: string,
    dateDebut: string,
    dateDernierAvenant: string,
    dateFin: string,
    etablissement: string,
    adresseEtablissement: AddressData,
    numeroContrat: string,
    departement: string,
    isActive:boolean;
    typeCalcul?:string;
    grillePrix?:string;
    colorCode?:string;
    observation?: string;
    numeroLot: string;
    dureeTrajet?:string;
  };

  export type IcircuitTrajet = {
    id: string,
    numeroTrajet: string;
    preparation: string;
    dateDebut: string;
    intitule: string;
    sensAR: Sens;
    ets: string;
    kmEtTemps: string;
    usagers: string[];
    codeTrajetCircuit: string;
    circuit: string;
    etat: EtatTrajet;
    chauffeur: string;
  }

  export interface IAvenant {
    id: string;
    dateApplication: string;
    etat: string;
    codeCircuit: string;
    codeAvenant: string;
    intitule: string;
    objetAvenant: string;
    type: string;
    dateFin: string;
    etablissement: string;
    chauffeur: string;
    departement: string;
    clientDO: string;
    isActive:boolean;
    objet?: string;
    typeCalcul?: string;

  }

  export enum Sens {
    Aller = 'aller',
    Retour = 'retour',
  }
  export enum Etat {
    NonControle = 'non_controle',
    Controle = 'controle',
  }

  export interface ICircuitContract {
    id: string;
    numeroContrat: string;
    contrat: string;
    circuit: string;
    numeroLot: string[];
    isActive?: boolean;
  }

  export type IPreparationCircuit = {
    id: string,
    codeCircuit: string,
    intitule: string,
    dateDebut: string,
    dateFin: string,
    etablissement: string,
    etat?: string,
    kmAVide?: string,
    typeCalcul?: string,
    adresseEtablissement: AddressData,
    colorCode?: string,
    toll?: string,
    usagers?: string[],
    observation?: string,
  };


  // Backend Interfaces
  export interface Circuit extends BaseDocument {
    circuitState: CircuitState;
    circuitCode: string;
    titled: string;
    driverName: string;
    startDate: string;
    endDate: string;
    lastAmendmentDate: string;
    establishmentName: string;
    establishmentAddress: string;
    contractCode: string;
    lotNumber: string;
    departmentName: string;
    timeTolerance: number;
    isSupported: boolean;
    isBilled: boolean;
    clientId: number;
    departmentId: number;
    calculationType: CalculationType;
    priceGrid: number;
    colorCode: string;
    isInternal: boolean;
    observation: string;
    mainDriver: number;
    mainEstablishment: number;
    active: boolean;
    idDocs: number[];
  }
  export interface SearchCircuitParams {
    id?: string;
    circuitCode?: string;
    circuitState?: CircuitState;
    driverName?: string;
    startDate?: string;
    endDate?: string;
    establishmentName?: string;
    contractCode?: number;
    lotNumber?: string;
    
    
    titled?: string;
    supported?: boolean;
    calculationType?: CalculationType;
    minPriceGrid?: number;
    colorCode?: string;
    billed?: boolean;
    internal?: boolean;
    observation?: string;
    active?: boolean;

    createdAt?: string;
    updatedAt?: string;
    sortBy?: string;
    sortDirection?: 'asc' | 'desc';
    page?: number;
    size?: number;
  }

  export interface BaseDocument {
    id: string;
    createdAt: string; 
    updatedAt: string; 
  }
  

  export enum CircuitState {
    CONTROLLED = 'CONTROLLED',
    UNCONTROLLED = 'UNCONTROLLED',
    ON_HOLD = 'ON_HOLD',
    UPDATED = 'UPDATED'
  }
  export enum CalculationType {
    URBAN = 'URBAN',
    RURAL = 'RURAL'
  }

  export interface SaveCircuit {
    circuitState: CircuitState;
    circuitCode: string;
    timeTolerance: number;
    titled: string;
    startDate: string; 
    endDate: string;   
    mainDriver: number;
    mainEstablishment: number;
    observation: string;
    colorCode: string;
    calculationType: CalculationType;
  }

  export const circuitStateOptions = [
    { value: CircuitState.CONTROLLED, label: 'Contrôlé' },
    { value: CircuitState.UNCONTROLLED, label: 'Non contrôlé' },
    { value: CircuitState.ON_HOLD, label: 'En attente' },
    { value: CircuitState.UPDATED, label: 'Mis à jour' }
  ];
  
  export const calculationTypeOptions = [
    { value: CalculationType.URBAN, label: 'Calcul pour les Coûts' },
    { value: CalculationType.RURAL, label: 'Autres calculs' }
  ];

  export interface ITripDriverAssignment extends BaseDocument {
    assignmentStartDate: string;
    assignmentEndDate: string;
    tripId: string;
    driverId: number;
    replacedByDriverId: number;
    observations: string;
    isActive: boolean;
    weeklyAssignmentSchedule: WeekTypeSchedule[];
  }

  export interface WeekTypeSchedule {
    weekType: WeekType;
    periods: DaySchedule[];
  }

  export interface DaySchedule {
    dayOfWeek: DaysOfWeek;
    periodOfDay: PeriodOfDay;
  }

  export interface AddPassengerToCircuit {
    circuitId: string;
    passengersIds: number[];
  }
  
  export interface AddPassengersToCircuitResponse {
    passengerId: number;
    firstName: string;
    lastName: string;
    birthDate: string;
    birthPlace: string;
    establishmentName: string;
    schoolClass: string;
    address: string[];
  }