import { DriverAbsenceStatut } from "../api/stores/driverAbsenceStore"
import { EtatDemandeRecue } from "./absence"
import { DocumentDTO } from "./document"
import { IDriverType } from "./driver"
import { Departements } from "./etablissement"
import { BinaryQuestion } from "./trajet"

export enum TraiteStatut {
  Valide = 'valide',
  Rejete = 'non_valide'
}
export enum DriverAbsenceStatus {
  EnCours = EtatDemandeRecue.EnCours,
  NonTraite = EtatDemandeRecue.NonTraite,
  Valide = TraiteStatut.Valide,
  Rejete = TraiteStatut.Rejete
}

export interface IDriverAbsence {
  id: string
  chauffeur: string
  driverName: string
  typeAbsence: string
  dateDebut: string
  dateFin: string
  chauffeurAffecte: BinaryQuestion
  modeReception: string
  department: string
  nombreHeures: string
  autorisePar: string | null
  validePar: string | null
  statut: DriverAbsenceStatut
  justificatif: File
  supportingDocumentId?: number
  driver?: IDriverType
}

export interface IDriverAbsenceWithDocument {
  id: string
  chauffeur: string
  driver: IDriverType
  driverName: string
  typeAbsence: string
  dateDebut: string
  dateFin: string
  chauffeurAffecte: BinaryQuestion
  modeReception: string
  department: Departements
  nombreHeures: string
  autorisePar: string | null
  validePar: string | null
  status: DriverAbsenceStatut
  justificatif: number
}