import { IRole } from './client';

export interface IAgent {
  id: number;
  lastName: string;
  firstName: string;
  email: string;
  phoneNumber: string;
  photoUrl: string | null;
  roles?: IRole[];
}

export interface IDepartment {
  id: number;
  name: string;
}

export interface IEquipe {
  id: string;
  name: string;
  teamCode: string;
  teamLeaderId: number;
  teamLeaderFullName: string;
  department: { id: number };
  collaborators: IAgent[];
  creationDate: string;
  status: TeamStatus;
}

export type TeamList = {
  id: string;
  name: string;
  teamCode: string;
  teamLeaderName: string;
  departmentName: string;
  creationDate: string;
  status: TeamStatus;
};
export type TeamMinimal = {
  id: number;
  name: string;
};

export type TeamRequest = {
  id?: string;
  name: string;
  teamCode?: string;
  teamLeaderId: number;
  teamLeaderFullName?: string;
  department: { id: number };
  collaborators: { id: number; firstName?: string; lastName?: string }[];
  creationDate: string;
  status: TeamStatus;
};

export enum TeamStatus {
  ACTIVE = 'ACTIVE',
  INACTIVE = 'INACTIVE',
}

export const TEAM_STATUS = [
  { value: TeamStatus.ACTIVE, label: 'Actif' },
  { value: TeamStatus.INACTIVE, label: 'Inactif' },
];

export const mapTeamToRequest = (team: IEquipe): TeamRequest => ({
  id: team.id,
  name: team.name,
  teamLeaderId: Number(team.teamLeaderId) || 0,
  department: { id: Number(team.department.id) || 0 },
  collaborators: team.collaborators?.map((agent) => ({ id: Number(agent.id) })) || [],
  creationDate: team.creationDate,
  status: team.status,
  teamCode: team.teamCode,
});

export type TeamPageFilterParams = {
  id?: string;
  name?: string;
  teamCode?: string;
  departmentName?: string;
  teamLeaderName?: string;
  status?: TeamStatus;
  creationDateStart?: string;
  creationDateEnd?: string;
  sortBy?: string;
  sortDirection?: 'asc' | 'desc';
  page?: number;
  size?: number;
};
