import { TableColumn } from "./common";

export interface RoadMapPageFilterParams {
  status: string;
  page?: number;
  size?: number;
  sortBy?: string;
  sortDirection?: 'asc' | 'desc';

}
export type IRoadmap = {
  id: string;
  name: string;
  driverName: string;
  driverId: string;
  date: string;
  nombreHeures: string;
  status: RoadMapStatus;
  phone: string;
  email: string;
};
export enum RoadMapStatus {
  Valid = 'VALIDE',
  NotValid = 'NON_VALIDE',
  InProgress = 'IN_PROGRESS',
}
export const INITIAL_DRIVER_ROADMAP_DATA: IRoadmap = {
  id: '',
  name: '',
  driverName: '',
  driverId: '',
  date: '',
  nombreHeures: '',
  status: RoadMapStatus.NotValid,
  phone: '',
  email: '',
};
export const DEFAULT_DRIVER_ROADMAP_TABLE_HEAD: TableColumn[] = [
  { id: 'driverName', label: 'Nom du chauffeur', type: 'text', align: 'left' },
  { id: 'date', label: 'Date', type: 'date', align: 'left' },
  { id: 'status', label: 'Status', type: 'status', align: 'left' },
  { id: 'nombreHeures', label: 'Nombre d\'heures', type: 'text',align: 'center', width:150},
  { id: 'contacter', label: 'Contacter', type: 'action', align: 'center' },
  { id: 'anciennesListes', label: 'Anciennes listes', type: 'action', align: 'center' },
];

export const ROADMAP_STATUS_OPTIONS = [
  { value: 'VALIDE', label: 'Traitée' },
  { value: 'NON_VALIDE', label: 'Non traitée' },
  { value: 'IN_PROGRESS', label: 'En cours' },
];

export interface SubmittedRoadMapDTO {
  id: string;
  isSubmitted: boolean;
  driverId: number;
  driverName: string;
  departementId: number;
  departementName: string;
  email : string;
  phone:string;
}

export interface SubmittedRoadMapFilterParams {
  driverName?: string;
  departementName?: string;
  isSubmitted?: boolean;
  sortBy?: string;
  sortDirection?: 'asc' | 'desc';
  page?: number;
  size?: number;
}

export const INITIAL_SUBMITTED_ROADMAP_DATA: SubmittedRoadMapDTO = {
  id: '',
  isSubmitted: false,
  driverId: 0,
  driverName: '',
  departementId: 0,
  departementName: '',
  email: '',
  phone: '',
  };


  export interface DriverRoadMapDetailsDTO {
    id: number;
    name: string;
    firstName: string;
    lastName: string;
    cardNumber: string;
    immatriculation: string;
    licenceNumber: string;
    date: string;
    driverName: string;
    driverId: number;
    departementName: string;
    departementAddress: string;
    departementId: number;
    workedDays: WorkedDayDTO[];
  }
  
  export interface WorkedDayDTO {
    driverRoadMapId: number;
    date: string;
    fuelAmount: number;
    observation: string;
    mileageIntervall: {
      startMileage: number;
      endMileage: number;
    } | null;
    roads: {
      type: string;
      startHour: string;
      endHour: string;
    }[];
    otherTrips: {
      type: string;
      startHour: string;
      endHour: string;
    }[];
  }

  export interface MileageIntervalDTO {
    startMileage: number;
    endMileage: number;
  }
  
  export interface RoadDTO {
    startHour: string;
    endHour: string;
    type: string;
  }
  
  export interface OtherTripDTO {
    startHour: string;
    endHour: string;
    type: string;
  }
  export interface OldRoadMapByDriverFilterParams {
    driverId?: number;
    name?: string;
    date?: string;
    page?: number;
    size?: number;
    sortBy?: string;
    sortDirection?: 'asc' | 'desc';
  }
export interface IRoadMapStatistics {  
  activeDrivers: number;
  submittedRoadmaps: number;
  notValidatedRoadmaps: number;
  notSubmittedRoadmaps: number;
  }