#!/bin/bash
set -e

# Function to read the current version from pom.xml
get_current_version() {
  mvn help:evaluate -Dexpression=project.version -q -DforceStdout
}

# Read the current version from pom.xml
CURRENT_VERSION=$(get_current_version)
RELEASE_VERSION=${CURRENT_VERSION/-SNAPSHOT/-RELEASE}

echo "Current version: $CURRENT_VERSION"
echo "Release version: $RELEASE_VERSION"

git remote set-url origin "https://oauth2:${GITLAB_API_TOKEN}@${GITLAB_PROJECT_URL}"


# Update pom.xml to release version, commit and tag
mvn versions:set -DnewVersion=$RELEASE_VERSION -DgenerateBackupPoms=false
mvn versions:commit
git add pom.xml
git commit -m "Prepare release $RELEASE_VERSION [skip ci]"
git tag -a  $RELEASE_VERSION -m "Release $RELEASE_VERSION"

# Push changes to develop branch along with tags
git push origin HEAD:develop --tags

# Create the release via API
curl --header "Content-Type: application/json" \
     --header "PRIVATE-TOKEN: $GITLAB_API_TOKEN" \
     --data "{
       \"name\": \"Release of $RELEASE_VERSION\",
       \"tag_name\": \"$RELEASE_VERSION\",
       \"ref\": \"develop\"
     }" \
     --request POST "https://mc-git.com/api/v4/projects/$CI_PROJECT_ID/releases"

# Determine the next snapshot version
IFS='.' read -ra ADDR <<< "${CURRENT_VERSION/-SNAPSHOT/}"
if [ ${ADDR[2]} -eq 999 ]; then
    if [ ${ADDR[1]} -eq 99 ]; then
        NEXT_SNAPSHOT="$((ADDR[0]+1)).0.0-SNAPSHOT"
    else
        NEXT_SNAPSHOT="${ADDR[0]}.$((ADDR[1]+1)).0-SNAPSHOT"
    fi
else
    NEXT_SNAPSHOT="${ADDR[0]}.${ADDR[1]}.$((ADDR[2]+1))-SNAPSHOT"
fi

echo "Next snapshot version: $NEXT_SNAPSHOT"

# Output new tag for next stages
echo $RELEASE_VERSION > release_version
echo $NEXT_SNAPSHOT > next_snapshot_version
