package com.marketingconfort.adanev.vsn.absence.models;

import com.marketingconfort.adanev.vsn.absence.enums.AbsenceType;
import com.marketingconfort.adanev.vsn.absence.enums.LeaveType;
import com.marketingconfort.adanev.vsn.absence.enums.RequestType;
import com.marketingconfort.adanev.vsn.absence.enums.State;
import com.marketingconfort.adanev.vsn.circuit.enums.ReceivingMethod;
import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import jakarta.persistence.*;
import lombok.*;

import java.time.LocalDate;
import java.util.List;

@Entity
@Table(name = "agent_absence")
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Getter
@Setter
public class AgentAbsence extends BaseEntity {

    private Long userId;
    @Enumerated(EnumType.STRING)
    private RequestType requestType;

    @Enumerated(EnumType.STRING)
    private AbsenceType absenceType;

    @Enumerated(EnumType.STRING)
    private LeaveType leaveType;
    private State state;

    private LocalDate startDate;
    private LocalDate endDate;

    private Integer numberOfDays;
    private String observations;
    private String comment;

    private LocalDate submittedAt;
    private LocalDate processedAt;
    private LocalDate forecastDate;
    @Column(name = "justification_file_url")
    private String justificationFileUrl;
    private ReceivingMethod receivingMethod;

    @ElementCollection
    private List<Integer> tripsIds;
}