package com.marketingconfort.adanev.vsn.absence.models;

import com.marketingconfort.adanev.vsn.absence.enums.AttendanceSheetStatus;
import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import jakarta.persistence.*;
import lombok.*;

import java.time.LocalDate;
import java.util.List;

@Entity
@Table(name = "attendance_sheet")
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Getter
@Setter
public class AttendanceSheet extends BaseEntity {
    @Column(nullable = false)
    private String number;
    @Column(nullable = false)
    private Long departmentId;
    @Column(nullable = false)
    private String circuitId;
    @Enumerated(EnumType.STRING)
    private AttendanceSheetStatus status;
    @Column(nullable = false)
    private Integer month;
    @Column(nullable = false)
    private Integer year;
    @Column(name = "school_days_count")
    private Integer schoolDaysCount;
    @Column(name = "presence_days_count")
    private Integer presenceDaysCount;
    @Column(name = "absence_days_count")
    private Integer absenceDaysCount;
    @Column(name = "transport_ar_count")
    private Integer transportARCount;
    @ElementCollection
    @CollectionTable(
            name = "attendance_absences",
            joinColumns = @JoinColumn(name = "attendance_sheet_id")
    )
    @Column(name = "absence_id")
    private List<Long> absence_id;

}
