package com.marketingconfort.adanev.vsn.absence.models;

import com.marketingconfort.adanev.vsn.absence.enums.ConcernedTrip;
import com.marketingconfort.adanev.vsn.circuit.enums.ReceivingMethod;
import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import jakarta.persistence.*;
import lombok.*;
import com.marketingconfort.adanev.vsn.absence.enums.State;

import java.time.LocalDate;
import java.util.Set;

@Entity
@Table(name = "passenger_absence")
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Getter
@Setter
public class PassengerAbsence extends BaseEntity {
    private Long passengerId;
    private State state;
    private LocalDate startDate;
    private LocalDate endDate;
    @ElementCollection(targetClass = ConcernedTrip.class)
    @CollectionTable(
            name = "passenger_absence_concerned_trips",
            joinColumns = @JoinColumn(name = "passenger_absence_id")
    )
    @Column(name = "concerned_trip")
    private Set<ConcernedTrip> concernedTrip;
    private String observations;
    private LocalDate forecastDate;
    private String comment;
    private ReceivingMethod receivingMethod;
    private String reportedBy;

}
