package com.marketingconfort.adanev.vsn.admin.models;

import com.marketingconfort.adanev.vsn.admin.enumerations.AddressType;
import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import jakarta.persistence.*;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import lombok.*;

@Entity
@Table(name = "address")
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Getter
@Setter
public class Address extends BaseEntity {

    @Column(name = "street")
    private String street;

    @Column(name = "zip_code")
    @NotNull(message = "Zip code cannot be null")
    @Pattern(regexp = "^[0-9]+$", message = "Zip code must only contain digits")
    @Size(min = 1, message = "Zip code must not be empty")
    private String zipCode;

    @Column(name = "city")
    @NotNull(message = "City cannot be null")
    @Size(min = 1, message = "City must not be empty")
    private String city;

    @Column(name = "country")
    @NotNull(message = "Country cannot be null")
    @Size(min = 1, message = "Country must not be empty")
    private String country;

    @Column(name = "additional_address")
    private String additionalAddress;

    @Column(name = "latitude")
    @NotNull(message = "Latitude cannot be null")
    private double latitude;

    @Column(name = "longitude")
    @NotNull(message = "Longitude cannot be null")
    private double longitude;

    @Enumerated(EnumType.STRING)
    @Column(name = "address_type")
    @NotNull(message = "Address type cannot be null")
    private AddressType addressType;

}
