package com.marketingconfort.adanev.vsn.admin.models;

import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import jakarta.persistence.*;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.*;
import com.fasterxml.jackson.annotation.JsonIgnore;

import java.util.List;

@Entity
@Table(name = "agency")
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Getter
@Setter
public class Agency extends BaseEntity {

    @NotNull
    @Size(min = 1)
    @Column(unique = true, nullable = false)
    private String name;

    @Size(max = 255)
    private String description;

    @OneToOne
    @JoinColumn(name = "address_id")
    private Address address;

    @NotNull
    @Min(0)
    private int departmentsNbr;

    @Column(nullable = false)
    private boolean active;

    @Column(nullable = false)
    private boolean archived;

    @ManyToOne
    @JoinColumn(name = "sector_id")
    @JsonIgnore
    private Sector sector;

    @OneToMany(mappedBy = "agency", cascade = CascadeType.ALL, orphanRemoval = true)
    @JsonIgnore
    private List<Department> departments;
}
