package com.marketingconfort.adanev.vsn.admin.models;

import com.marketingconfort.adanev.vsn.admin.enumerations.CalendarDayType;
import com.marketingconfort.adanev.vsn.admin.enumerations.DayOfWeek;
import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import jakarta.persistence.*;
import lombok.*;

import java.util.Date;

@Entity
@Table(name = "calendar_day")
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Getter
@Setter
public class CalendarDay extends BaseEntity {
    @Column(name = "name")
    private String name;

    @Column(name = "day_of_day")
    private Date dayOfDay;

    @Enumerated(EnumType.STRING)
    @Column(name = "day_type")
    private CalendarDayType dayType;

    @Enumerated(EnumType.STRING)
    @Column(name = "day_of_week")
    private DayOfWeek dayOfWeek;

    @ManyToOne
    @JoinColumn(name = "calendar_month_id", nullable = false)
    private CalendarMonth calendarMonth;
}
