package com.marketingconfort.adanev.vsn.admin.models;

import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import jakarta.persistence.*;
import lombok.*;

import java.util.List;

@Entity
@Table(name = "calendar_month")
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Getter
@Setter
public class CalendarMonth extends BaseEntity {
    @ManyToOne
    @JoinColumn(name = "calendar_year_id", nullable = false)
    private CalendarYear calendarYear;

    @OneToMany(mappedBy = "calendarMonth", cascade = CascadeType.ALL, orphanRemoval = true)
    private List<CalendarDay> days;
}
