package com.marketingconfort.adanev.vsn.admin.models;

import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import jakarta.persistence.*;
import lombok.*;

import java.util.List;

@Entity
@Table(name = "calendar_year")
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Getter
@Setter
public class CalendarYear extends BaseEntity {
    @Column(name = "year")
    private int year;

    @OneToMany(mappedBy = "calendarYear", cascade = CascadeType.ALL, orphanRemoval = true)
    private List<CalendarMonth> months;
}
