package com.marketingconfort.adanev.vsn.admin.models;


import com.marketingconfort.adanev.vsn.admin.enumerations.ContractStatus;
import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import jakarta.persistence.*;
import lombok.*;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name = "contrat")
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Getter
@Setter
public class Contract extends BaseEntity {

    @Column(nullable = false, unique = true)
    private String title;

    @Column(name ="contract_code", nullable = false, unique = true)
    private String contractCode;

    @Column(name = "start_date")
    private LocalDateTime startDate;

    @Column(name = "end_date")
    private LocalDateTime endDate;

    @Column(name = "market_date")
    private LocalDateTime marketDate;

    @Column(name = "renewal_date")
    private LocalDateTime renewalDate;

    @Column(name = "price_revision_date")
    private LocalDateTime priceRevisionDate;

    private String marketNumber;

    @Enumerated(EnumType.STRING)
    private ContractStatus status;

    @Column(name = "pricing_grid_type")
    private double pricingGridType;

    @Column(name = "price_revision_frequency_months")
    private int priceRevisionFrequencyMonths;

    @Column(name = "contract_color")
    private String contractColor;

    @Column(name = "commitment_number")
    private String commitmentNumber;

    @Column(name = "contract_duration_months")
    private int contractDurationMonths;

    @Column(name = "renewal_status")
    private boolean renewalStatus;

    @Column(name = "tad_type")
    private boolean tadType;

    @ElementCollection
    @CollectionTable(name = "contract_documents", joinColumns = @JoinColumn(name = "contract_id"))
    @Column(name = "document_id")
    private List<String> documentIds = new ArrayList<>();

    @ElementCollection
    private List<String> circuitsIDs = new ArrayList<>();

    @ManyToOne
    @JoinColumn(name = "agency_id", nullable = false)
    private Agency agency;

    @ManyToOne
    @JoinColumn(name = "department_id", nullable = false)
    private Department department;

    @ManyToOne
    @JoinColumn(name = "lot_id", nullable = false)
    private Lot lot;

    private String observation;

    private boolean active;

}
