package com.marketingconfort.adanev.vsn.admin.models;

import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import jakarta.persistence.*;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.*;
import com.fasterxml.jackson.annotation.JsonIgnore;

import java.util.List;

@Entity
@Table(name = "department")
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Getter
@Setter
public class Department extends BaseEntity {

    @NotNull
    @Size(min = 1, max = 100)
    @Column(unique = true, nullable = false)
    private String name;

    @Size(max = 255)
    private String description;

    @OneToOne
    @JoinColumn(name = "address_id")
    private Address address;

    @NotNull
    @Min(0)
    private int lotsNbr;

    @Column(nullable = false)
    private boolean active;

    @Column(nullable = false)
    private boolean archived;

    @ManyToOne
    @JoinColumn(name = "agency_id")
    @JsonIgnore
    private Agency agency;

    @ManyToMany(mappedBy = "departments")
    @JsonIgnore
    private List<Lot> lots;

    @OneToMany(mappedBy = "department", cascade = CascadeType.ALL, orphanRemoval = true)
    @JsonIgnore
    private List<Establishment> establishments;

}
