package com.marketingconfort.adanev.vsn.admin.models;

import com.marketingconfort.adanev.vsn.admin.enumerations.EstablishmentSector;
import com.marketingconfort.adanev.vsn.admin.enumerations.EstablishmentType;
import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import jakarta.persistence.*;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.*;

import java.util.List;

@Entity
@Table(name = "establishment")
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Getter
@Setter
public class Establishment extends BaseEntity {

    @Column(name = "establishment_code", nullable = false, unique = true)
    @NotBlank(message = "Establishment code is required.")
    private String establishmentCode;

    @Column(name = "establishment_name", nullable = false, unique = true)
    @NotBlank(message = "Establishment name is required.")
    private String establishmentName;

    @ManyToOne(optional = false)
    @JoinColumn(name = "address_id", nullable = false)
    @NotNull(message = "Address is required.")
    private Address address;

    @Enumerated(EnumType.STRING)
    @Column(name = "establishment_sector", nullable = false)
    @NotNull(message = "Sector (public/private) is required.")
    private EstablishmentSector establishmentSector;

    @Column(name = "uai_code", nullable = false, unique = true)
    @NotBlank(message = "UAI code (school zone) is required.")
    private String uaiCode;

    @Column(name = "phone_number", nullable = false)
    @NotBlank(message = "Phone number is required.")
    private String phoneNumber;

    @Enumerated(EnumType.STRING)
    @Column(name = "establishment_type", nullable = false)
    @NotNull(message = "Establishment type is required.")
    private EstablishmentType establishmentType;

    @Column(name = "color_code", nullable = false)
    @NotBlank(message = "Color code is required.")
    private String colorCode;

    private String fax;

    @Column(nullable = false)
    @NotBlank(message = "Email is required.")
    private String email;

    private String website;

    private String doId;

    private String doCode;

    private Long documentId;

    private String observation;

    @ElementCollection
    @NotEmpty(message = "At least one responsible ID must be present.")
    private List<Long> establishmentResponsibleIds;

    @OneToMany(mappedBy = "establishment", cascade = CascadeType.ALL, orphanRemoval = true, fetch = FetchType.LAZY)
    private List<EstablishmentHours> hours;

    @ManyToOne(fetch = FetchType.LAZY, cascade = {CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name = "department_id", nullable = false)
    @NotNull(message = "Department is required.")
    private Department department;

    @ManyToOne(fetch = FetchType.LAZY, cascade = {CascadeType.MERGE, CascadeType.PERSIST})
    @JoinColumn(name = "zone_id", nullable = false)
    @NotNull(message = "Zone is required.")
    private Zone zone;

    @Column(nullable = false)
    @Size(min = 1)
    private String academy;

    @Column(nullable = false)
    private boolean archived;

    @Column(nullable = false)
    private boolean active;
}
