package com.marketingconfort.adanev.vsn.admin.models;

import com.marketingconfort.adanev.vsn.admin.enumerations.DayOfWeek;
import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import jakarta.persistence.*;
import lombok.*;

import java.time.LocalTime;

@Entity
@Table(name = "establishment_hours")
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Getter
@Setter
public class EstablishmentHours extends BaseEntity {

    @Enumerated(EnumType.STRING)
    @Column(name = "day_of_week", nullable = false)
    private DayOfWeek dayOfWeek;

    @Column(name = "morning_opening_time", nullable = false)
    private LocalTime morningOpeningTime;

    @Column(name = "evening_closing_time", nullable = false)
    private LocalTime eveningClosingTime;

    @ManyToOne
    @JoinColumn(name = "establishment_id", nullable = false)
    private Establishment establishment;
}
