package com.marketingconfort.adanev.vsn.admin.models;

import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import jakarta.persistence.*;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.*;
import com.fasterxml.jackson.annotation.JsonIgnore;

import java.util.List;

@Entity
@Table(name = "lot")
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Getter
@Setter
public class Lot extends BaseEntity {

    @NotNull
    @Size(min = 1)
    @Column(unique = true, nullable = false)
    private String number;

    @Size(max = 255)
    private String description;

    @Column(nullable = false)
    private boolean active;

    @Column(nullable = false)
    private boolean archived;

    @ManyToMany
    @JoinTable(
            name = "lot_department",
            joinColumns = @JoinColumn(name = "lot_id"),
            inverseJoinColumns = @JoinColumn(name = "department_id")
    )
    @JsonIgnore
    private List<Department> departments;

}
