package com.marketingconfort.adanev.vsn.admin.models;

import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import jakarta.persistence.*;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.*;

import java.util.Date;

@Entity
@Table(name = "public_holiday")
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Getter
@Setter
public class PublicHoliday extends BaseEntity {
    @NotNull
    @Size(min = 1)
    @Column(nullable = false)
    private String name;

    @NotNull
    @Column(name = "date_of_day")
    private Date dateOfDay;

    @ManyToOne
    @JoinColumn(name = "zone_id")
    private Zone zone;
}
