package com.marketingconfort.adanev.vsn.admin.models;

import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import com.marketingconfort.adanev.vsn.document.enums.DocumentType;
import com.marketingconfort.adanev.vsn.document.enums.PriorityLevel;
import com.marketingconfort.adanev.vsn.document.enums.RequestStatus;
import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDate;
import java.time.LocalDateTime;

@Entity
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "document_requests")
public class Request extends BaseEntity {

    @Column(name = "code_req", nullable = false)
    private String codeReq;

    @Column(name = "user_id", nullable = false)
    private long userId;

    @Enumerated(EnumType.STRING)
    @Column(nullable = false)
    private DocumentType type;

    @Enumerated(EnumType.STRING)
    @Column(nullable = false)
    private RequestStatus statut;

    @Column(name = "submission_date")
    private LocalDate submissionDate;

    @Column(name = "processing_date")
    private LocalDateTime processingDate;

    @Enumerated(EnumType.STRING)
    private PriorityLevel priority;

    private String observation;

    private String description;
}
