package com.marketingconfort.adanev.vsn.admin.models;

import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import jakarta.persistence.*;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.*;

import java.util.Date;

@Entity
@Table(name = "school_holiday")
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Getter
@Setter
public class SchoolHoliday extends BaseEntity {
    @NotNull
    @Size(min = 1)
    @Column(nullable = false)
    private String name;

    private Date startDate;

    private Date endDate;

    private String population;

    @Column(nullable = false)
    @Size(min = 1)
    private String academy;

    @ManyToOne
    @JoinColumn(name = "zone_id")
    private Zone zone;
}
