package com.marketingconfort.adanev.vsn.circuit.models;

import com.marketingconfort.adanev.vsn.circuit.enums.AmendmentCreation;
import com.marketingconfort.adanev.vsn.circuit.enums.AmendmentType;
import com.marketingconfort.adanev.vsn.circuit.enums.TypeOfAction;
import com.marketingconfort.adanev.vsn.core.models.NoSqlBaseEntity;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDate;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public abstract class Amendment extends NoSqlBaseEntity {
    private String subject;
    private String observation;
    private boolean active;
    private AmendmentCreation creationType;
    private TypeOfAction actionType;
    private LocalDate startDate;
    private LocalDate endDate;
    private AmendmentType amendmentType;
}
