package com.marketingconfort.adanev.vsn.circuit.models;

import com.marketingconfort.adanev.vsn.circuit.enums.CalculationType;
import com.marketingconfort.adanev.vsn.circuit.enums.CircuitState;
import com.marketingconfort.adanev.vsn.core.models.NoSqlBaseEntity;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;

@Document(collection = "amendment_circuits")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class AmendmentCircuit extends Amendment {
    private CircuitState circuitState;
    private String amendmentCode;
    private CalculationType calculationType;
    private Double priceGrid;
    private String colorCode;
    private String triggeredAmendmentPassengerId;
    private boolean isBilled;
    private String url;
    private Long idEstablishment;
    private List<Long> idTrip;
}

