package com.marketingconfort.adanev.vsn.circuit.models;

import com.marketingconfort.adanev.vsn.circuit.enums.CalculationType;
import com.marketingconfort.adanev.vsn.circuit.enums.CircuitState;
import com.marketingconfort.adanev.vsn.core.models.NoSqlBaseEntity;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.mongodb.core.mapping.Document;


import java.time.LocalDateTime;
import java.util.List;

@Document(collection = "circuit")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class Circuit extends NoSqlBaseEntity {
    private CircuitState circuitState;
    private String circuitCode;
    private String titled;
    private boolean isSupported;
    private Double distanceKm;
    private CalculationType calculationType;
    private Double priceGrid;
    private LocalDateTime startDate;
    private LocalDateTime endDate;
    private String colorCode;
    private boolean isBilled;
    private boolean isInternal;
    private String observation;
    private List<String> idCircuitDriver;
    private List<Long> idPassenger;
    private Long idEstablishment;
    private List<Long> idAmendmentCircuit;
    private boolean isActive;
    private List<Long> idDocs;
}
