package com.marketingconfort.adanev.vsn.circuit.models;

import com.marketingconfort.adanev.vsn.circuit.enums.DriverRole;
import com.marketingconfort.adanev.vsn.core.models.NoSqlBaseEntity;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.mongodb.core.mapping.Document;

import java.time.LocalDateTime;

@Document(collection = "circuit_driver")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class CircuitDriver extends NoSqlBaseEntity {
    private DriverRole driverRole;
    private LocalDateTime assignmentStart;
    private LocalDateTime assignmentEnd;
    private boolean isAssigned;
    private Long idCircuit;
}
