package com.marketingconfort.adanev.vsn.circuit.models;

import com.marketingconfort.adanev.vsn.circuit.enums.DaysOfWeek;
import com.marketingconfort.adanev.vsn.circuit.enums.SensTrip;
import com.marketingconfort.adanev.vsn.circuit.enums.WeekType;
import com.marketingconfort.adanev.vsn.core.models.NoSqlBaseEntity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.mongodb.core.mapping.Document;

import java.time.LocalTime;
import java.util.Map;

@Document(collection = "passenger_schedule_week")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class PassengerScheduleWeek extends NoSqlBaseEntity {
    @Enumerated(EnumType.STRING)
    private WeekType weekType;
    private Map<String, LocalTime> dayScheduleAmendment;

}
