package com.marketingconfort.adanev.vsn.circuit.models;

import com.marketingconfort.adanev.vsn.circuit.enums.DaysOfWeek;
import com.marketingconfort.adanev.vsn.circuit.enums.PeriodOfDay;
import com.marketingconfort.adanev.vsn.circuit.enums.WeekType;
import com.marketingconfort.adanev.vsn.core.models.NoSqlBaseEntity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Map;

@Document(collection = "transportSchedule_amendment")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class TransportScheduleAmendment extends NoSqlBaseEntity {
    @Enumerated(EnumType.STRING)
    private WeekType weekType;
    private Map<String, Boolean> dayScheduleAmendments;

}
