package com.marketingconfort.adanev.vsn.circuit.models;

import com.marketingconfort.adanev.vsn.circuit.enums.*;
import com.marketingconfort.adanev.vsn.core.models.NoSqlBaseEntity;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.mongodb.core.mapping.Document;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

@Document(collection = "trip")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class Trip extends NoSqlBaseEntity {
    private SensTrip sens;
    private Double distanceKm;
    private String duration;
    private int passengerCount;
    private LocalDateTime startDate;
    private LocalDateTime endDate;
    private TripState tripState;
    private TripType tripType;
    private Double emptyKm;
    private PickupType pickupType;
    private WeekType weekType;
    private PeriodOfDay periodOfDay;
    private List<String> idListTrip;
    private List<Long> idPassenger;
    private List<Long> idEstablishment;
    private Long driverId;
    private Long vehicleId;
    private Long companyId;
    private Long clientId;
    private String driverName;
    private String vehicleName;
    private String origin;
    private String destination;
    private Boolean hasTolls;
    private String title;
    private Boolean rotation;
    private String circuitId;
    private LocalDate avenantDate;
    private LocalDate customizedDate;
    private String customizationNote;
    private String routeSheetNote;
    private List<String> tripDayIds;
}


