package com.marketingconfort.adanev.vsn.circuit.models;

import com.marketingconfort.adanev.vsn.circuit.enums.DaysOfWeek;
import com.marketingconfort.adanev.vsn.core.models.NoSqlBaseEntity;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.mongodb.core.mapping.Document;

import java.time.LocalDateTime;

@Document(collection = "trip_day")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class TripDay extends NoSqlBaseEntity {
    private DaysOfWeek dayOfWeek;
    private LocalDateTime date;
    private Long driverId;
    private String idTrip;
    private boolean isAbsent;
    private Long replacedBy;
}

