package com.marketingconfort.adanev.vsn.circuit.models;

import com.marketingconfort.adanev.vsn.core.models.NoSqlBaseEntity;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.mongodb.core.mapping.Document;
@Document(collection = "trip_point")
@Getter @Setter @NoArgsConstructor @AllArgsConstructor
public class TripPoint extends NoSqlBaseEntity {
    private String tripId;
    private Integer sequenceOrder;
    private String label;
    private Long passengerId;
    private String passengerName;
    private CustomAddress address;
    private Double latitude;
    private Double longitude;
    private String arrivalTime;
    private String departureTime;
    private Double distanceFromPreviousPoint;
    private Integer timeFromPreviousPoint;
    private Boolean isTemporaryForUser;

    @Getter @Setter @NoArgsConstructor @AllArgsConstructor
    public static class CustomAddress {
        private String fullAddress;
        private String street;
        private String postalCode;
        private String city;
        private String country;
    }
}
