package com.marketingconfort.adanev.vsn.document.models;

import com.marketingconfort.adanev.vsn.core.models.BaseEntity;
import com.marketingconfort.adanev.vsn.document.enums.ContentType;
import com.marketingconfort.adanev.vsn.document.enums.DocumentType;
import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Entity
@Table(name = "documents")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class Document extends BaseEntity {

    @Column(nullable = false)
    private String name;
    private String path;
    private Long size;

    @Enumerated(EnumType.STRING)
    @Column(name = "content_type")
    private ContentType contentType;

    @Column(name = "s3_key", length = 1024)
    private String s3Key;

    // Relationship with Folder
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "folder_id")
    private Folder folder;

    @Column(name = "owner_id")
    private long ownerId;

    @Column(name = "favorite", nullable = false)
    private boolean favorite = false;

    // Document type classification
    @Enumerated(EnumType.STRING)
    @Column(name = "document_type")
    private DocumentType documentType;
}